<?php

/**
 * This is the model class for table "Mapa".
 *
 * The followings are the available columns in table 'Mapa':
 * @property double $id
 * @property string $nazwaMiasta
 * @property string $urlTla
 */
class Mapa extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Mapa the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'Mapa';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		return array(
			array('nazwaMiasta', 'length', 'max'=>128),
			array('urlTla', 'length', 'max'=>512),

			array('id, nazwaMiasta, urlTla', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		return array(
			'budyneks'=>array(self::HAS_MANY, 'Budynek', 'idMapy'),
			'szkolas'=>array(self::HAS_MANY, 'Szkola', 'idMapy'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id'=>Yii::t('Mapa', 'id'),
			'nazwaMiasta'=>Yii::t('Mapa', 'nazwaMiasta'),
			'urlTla'=>Yii::t('Mapa', 'urlTla'),
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		$criteria = new CDbCriteria;

		$criteria->compare('id', $this->id);
		$criteria->compare('nazwaMiasta', $this->nazwaMiasta, true);
		$criteria->compare('urlTla', $this->urlTla, true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	public static function getNameByClass($classId)
	{
		return Yii::app()->db->createCommand('
			select m."nazwaMiasta" from "Klasa" k
			left join "Szkola" s on s."id" = k."idSzkoly"
			left join "Mapa" m on m."id" = s."idMapy"
			where k."id" = ?
		')->queryScalar(array($classId));
	}
}